// Code generated by ./gen/main.go. DO NOT EDIT.

package setof

import (
	"sort"

	"github.com/tinylib/msgp/msgp"
)

// String is a set of strings that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type String map[string]struct{}

// EncodeMsg encodes the message to the writer.
func (s String) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteString(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s String) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendString(bytes, string(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s String) AsSlice() []string {
	if s == nil {
		return nil
	}
	dst := make([]string, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *String) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(String, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k string
		k, err = reader.ReadString()
		if err != nil {
			return err
		}
		dst[string(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *String) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(String, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k string
		k, bytes, err = msgp.ReadStringBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[string(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s String) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	for key := range s {
		size += msgp.StringPrefixSize + len(key)
	}
	return size
}

// StringFromSlice creates a String from a slice.
func StringFromSlice(s []string) String {
	if s == nil {
		return nil
	}
	dst := make(String, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// StringSorted is a set of strings that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type StringSorted map[string]struct{}

// EncodeMsg encodes the message to the writer.
func (s StringSorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]string, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Strings(keys)

	for _, k := range keys {
		err = writer.WriteString(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s StringSorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]string, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Strings(keys)
	for _, k := range keys {
		bytes = msgp.AppendString(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s StringSorted) AsSlice() []string {
	if s == nil {
		return nil
	}
	dst := make([]string, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *StringSorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(StringSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k string
		k, err = reader.ReadString()
		if err != nil {
			return err
		}
		dst[string(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *StringSorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(StringSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k string
		k, bytes, err = msgp.ReadStringBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[string(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s StringSorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	for key := range s {
		size += msgp.StringPrefixSize + len(key)
	}
	return size
}

// StringSortedFromSlice creates a StringSorted from a slice.
func StringSortedFromSlice(s []string) StringSorted {
	if s == nil {
		return nil
	}
	dst := make(StringSorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int is a set of ints that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Int map[int]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteInt(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendInt(bytes, int(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Int) AsSlice() []int {
	if s == nil {
		return nil
	}
	dst := make([]int, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int
		k, err = reader.ReadInt()
		if err != nil {
			return err
		}
		dst[int(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int
		k, bytes, err = msgp.ReadIntBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.IntSize
	return size
}

// IntFromSlice creates a Int from a slice.
func IntFromSlice(s []int) Int {
	if s == nil {
		return nil
	}
	dst := make(Int, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// IntSorted is a set of ints that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type IntSorted map[int]struct{}

// EncodeMsg encodes the message to the writer.
func (s IntSorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]int, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteInt(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s IntSorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]int, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendInt(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s IntSorted) AsSlice() []int {
	if s == nil {
		return nil
	}
	dst := make([]int, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *IntSorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(IntSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int
		k, err = reader.ReadInt()
		if err != nil {
			return err
		}
		dst[int(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *IntSorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(IntSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int
		k, bytes, err = msgp.ReadIntBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s IntSorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.IntSize
	return size
}

// IntSortedFromSlice creates a IntSorted from a slice.
func IntSortedFromSlice(s []int) IntSorted {
	if s == nil {
		return nil
	}
	dst := make(IntSorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint is a set of uints that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Uint map[uint]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteUint(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendUint(bytes, uint(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Uint) AsSlice() []uint {
	if s == nil {
		return nil
	}
	dst := make([]uint, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint
		k, err = reader.ReadUint()
		if err != nil {
			return err
		}
		dst[uint(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint
		k, bytes, err = msgp.ReadUintBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.UintSize
	return size
}

// UintFromSlice creates a Uint from a slice.
func UintFromSlice(s []uint) Uint {
	if s == nil {
		return nil
	}
	dst := make(Uint, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// UintSorted is a set of uints that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type UintSorted map[uint]struct{}

// EncodeMsg encodes the message to the writer.
func (s UintSorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]uint, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteUint(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s UintSorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]uint, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendUint(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s UintSorted) AsSlice() []uint {
	if s == nil {
		return nil
	}
	dst := make([]uint, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *UintSorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(UintSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint
		k, err = reader.ReadUint()
		if err != nil {
			return err
		}
		dst[uint(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *UintSorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(UintSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint
		k, bytes, err = msgp.ReadUintBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s UintSorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.UintSize
	return size
}

// UintSortedFromSlice creates a UintSorted from a slice.
func UintSortedFromSlice(s []uint) UintSorted {
	if s == nil {
		return nil
	}
	dst := make(UintSorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Byte is a set of bytes that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Byte map[byte]struct{}

// EncodeMsg encodes the message to the writer.
func (s Byte) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteByte(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Byte) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendByte(bytes, byte(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Byte) AsSlice() []byte {
	if s == nil {
		return nil
	}
	dst := make([]byte, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Byte) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Byte, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k byte
		k, err = reader.ReadByte()
		if err != nil {
			return err
		}
		dst[byte(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Byte) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Byte, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k byte
		k, bytes, err = msgp.ReadByteBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[byte(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Byte) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.ByteSize
	return size
}

// ByteFromSlice creates a Byte from a slice.
func ByteFromSlice(s []byte) Byte {
	if s == nil {
		return nil
	}
	dst := make(Byte, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// ByteSorted is a set of bytes that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type ByteSorted map[byte]struct{}

// EncodeMsg encodes the message to the writer.
func (s ByteSorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]byte, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteByte(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s ByteSorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]byte, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendByte(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s ByteSorted) AsSlice() []byte {
	if s == nil {
		return nil
	}
	dst := make([]byte, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *ByteSorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(ByteSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k byte
		k, err = reader.ReadByte()
		if err != nil {
			return err
		}
		dst[byte(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *ByteSorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(ByteSorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k byte
		k, bytes, err = msgp.ReadByteBytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[byte(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s ByteSorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.ByteSize
	return size
}

// ByteSortedFromSlice creates a ByteSorted from a slice.
func ByteSortedFromSlice(s []byte) ByteSorted {
	if s == nil {
		return nil
	}
	dst := make(ByteSorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int8 is a set of int8s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Int8 map[int8]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int8) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteInt8(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int8) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendInt8(bytes, int8(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Int8) AsSlice() []int8 {
	if s == nil {
		return nil
	}
	dst := make([]int8, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int8) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int8, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int8
		k, err = reader.ReadInt8()
		if err != nil {
			return err
		}
		dst[int8(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int8) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int8, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int8
		k, bytes, err = msgp.ReadInt8Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int8(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int8) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int8Size
	return size
}

// Int8FromSlice creates a Int8 from a slice.
func Int8FromSlice(s []int8) Int8 {
	if s == nil {
		return nil
	}
	dst := make(Int8, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int8Sorted is a set of int8s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Int8Sorted map[int8]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int8Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]int8, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteInt8(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int8Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]int8, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendInt8(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Int8Sorted) AsSlice() []int8 {
	if s == nil {
		return nil
	}
	dst := make([]int8, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int8Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int8Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int8
		k, err = reader.ReadInt8()
		if err != nil {
			return err
		}
		dst[int8(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int8Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int8Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int8
		k, bytes, err = msgp.ReadInt8Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int8(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int8Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int8Size
	return size
}

// Int8SortedFromSlice creates a Int8Sorted from a slice.
func Int8SortedFromSlice(s []int8) Int8Sorted {
	if s == nil {
		return nil
	}
	dst := make(Int8Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint8 is a set of uint8s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Uint8 map[uint8]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint8) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteUint8(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint8) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendUint8(bytes, uint8(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Uint8) AsSlice() []uint8 {
	if s == nil {
		return nil
	}
	dst := make([]uint8, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint8) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint8, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint8
		k, err = reader.ReadUint8()
		if err != nil {
			return err
		}
		dst[uint8(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint8) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint8, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint8
		k, bytes, err = msgp.ReadUint8Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint8(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint8) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint8Size
	return size
}

// Uint8FromSlice creates a Uint8 from a slice.
func Uint8FromSlice(s []uint8) Uint8 {
	if s == nil {
		return nil
	}
	dst := make(Uint8, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint8Sorted is a set of uint8s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Uint8Sorted map[uint8]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint8Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]uint8, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteUint8(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint8Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]uint8, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendUint8(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Uint8Sorted) AsSlice() []uint8 {
	if s == nil {
		return nil
	}
	dst := make([]uint8, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint8Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint8Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint8
		k, err = reader.ReadUint8()
		if err != nil {
			return err
		}
		dst[uint8(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint8Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint8Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint8
		k, bytes, err = msgp.ReadUint8Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint8(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint8Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint8Size
	return size
}

// Uint8SortedFromSlice creates a Uint8Sorted from a slice.
func Uint8SortedFromSlice(s []uint8) Uint8Sorted {
	if s == nil {
		return nil
	}
	dst := make(Uint8Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int16 is a set of int16s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Int16 map[int16]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int16) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteInt16(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int16) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendInt16(bytes, int16(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Int16) AsSlice() []int16 {
	if s == nil {
		return nil
	}
	dst := make([]int16, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int16) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int16, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int16
		k, err = reader.ReadInt16()
		if err != nil {
			return err
		}
		dst[int16(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int16) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int16, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int16
		k, bytes, err = msgp.ReadInt16Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int16(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int16) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int16Size
	return size
}

// Int16FromSlice creates a Int16 from a slice.
func Int16FromSlice(s []int16) Int16 {
	if s == nil {
		return nil
	}
	dst := make(Int16, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int16Sorted is a set of int16s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Int16Sorted map[int16]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int16Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]int16, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteInt16(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int16Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]int16, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendInt16(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Int16Sorted) AsSlice() []int16 {
	if s == nil {
		return nil
	}
	dst := make([]int16, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int16Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int16Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int16
		k, err = reader.ReadInt16()
		if err != nil {
			return err
		}
		dst[int16(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int16Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int16Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int16
		k, bytes, err = msgp.ReadInt16Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int16(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int16Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int16Size
	return size
}

// Int16SortedFromSlice creates a Int16Sorted from a slice.
func Int16SortedFromSlice(s []int16) Int16Sorted {
	if s == nil {
		return nil
	}
	dst := make(Int16Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint16 is a set of uint16s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Uint16 map[uint16]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint16) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteUint16(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint16) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendUint16(bytes, uint16(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Uint16) AsSlice() []uint16 {
	if s == nil {
		return nil
	}
	dst := make([]uint16, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint16) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint16, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint16
		k, err = reader.ReadUint16()
		if err != nil {
			return err
		}
		dst[uint16(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint16) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint16, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint16
		k, bytes, err = msgp.ReadUint16Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint16(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint16) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint16Size
	return size
}

// Uint16FromSlice creates a Uint16 from a slice.
func Uint16FromSlice(s []uint16) Uint16 {
	if s == nil {
		return nil
	}
	dst := make(Uint16, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint16Sorted is a set of uint16s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Uint16Sorted map[uint16]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint16Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]uint16, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteUint16(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint16Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]uint16, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendUint16(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Uint16Sorted) AsSlice() []uint16 {
	if s == nil {
		return nil
	}
	dst := make([]uint16, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint16Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint16Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint16
		k, err = reader.ReadUint16()
		if err != nil {
			return err
		}
		dst[uint16(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint16Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint16Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint16
		k, bytes, err = msgp.ReadUint16Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint16(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint16Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint16Size
	return size
}

// Uint16SortedFromSlice creates a Uint16Sorted from a slice.
func Uint16SortedFromSlice(s []uint16) Uint16Sorted {
	if s == nil {
		return nil
	}
	dst := make(Uint16Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int32 is a set of int32s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Int32 map[int32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int32) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteInt32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int32) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendInt32(bytes, int32(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Int32) AsSlice() []int32 {
	if s == nil {
		return nil
	}
	dst := make([]int32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int32) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int32
		k, err = reader.ReadInt32()
		if err != nil {
			return err
		}
		dst[int32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int32) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int32
		k, bytes, err = msgp.ReadInt32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int32) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int32Size
	return size
}

// Int32FromSlice creates a Int32 from a slice.
func Int32FromSlice(s []int32) Int32 {
	if s == nil {
		return nil
	}
	dst := make(Int32, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int32Sorted is a set of int32s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Int32Sorted map[int32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int32Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]int32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteInt32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int32Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]int32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendInt32(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Int32Sorted) AsSlice() []int32 {
	if s == nil {
		return nil
	}
	dst := make([]int32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int32Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int32
		k, err = reader.ReadInt32()
		if err != nil {
			return err
		}
		dst[int32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int32Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int32
		k, bytes, err = msgp.ReadInt32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int32Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int32Size
	return size
}

// Int32SortedFromSlice creates a Int32Sorted from a slice.
func Int32SortedFromSlice(s []int32) Int32Sorted {
	if s == nil {
		return nil
	}
	dst := make(Int32Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint32 is a set of uint32s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Uint32 map[uint32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint32) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteUint32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint32) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendUint32(bytes, uint32(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Uint32) AsSlice() []uint32 {
	if s == nil {
		return nil
	}
	dst := make([]uint32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint32) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint32
		k, err = reader.ReadUint32()
		if err != nil {
			return err
		}
		dst[uint32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint32) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint32
		k, bytes, err = msgp.ReadUint32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint32) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint32Size
	return size
}

// Uint32FromSlice creates a Uint32 from a slice.
func Uint32FromSlice(s []uint32) Uint32 {
	if s == nil {
		return nil
	}
	dst := make(Uint32, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint32Sorted is a set of uint32s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Uint32Sorted map[uint32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint32Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]uint32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteUint32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint32Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]uint32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendUint32(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Uint32Sorted) AsSlice() []uint32 {
	if s == nil {
		return nil
	}
	dst := make([]uint32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint32Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint32
		k, err = reader.ReadUint32()
		if err != nil {
			return err
		}
		dst[uint32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint32Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint32
		k, bytes, err = msgp.ReadUint32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint32Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint32Size
	return size
}

// Uint32SortedFromSlice creates a Uint32Sorted from a slice.
func Uint32SortedFromSlice(s []uint32) Uint32Sorted {
	if s == nil {
		return nil
	}
	dst := make(Uint32Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int64 is a set of int64s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Int64 map[int64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int64) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteInt64(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int64) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendInt64(bytes, int64(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Int64) AsSlice() []int64 {
	if s == nil {
		return nil
	}
	dst := make([]int64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int64) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int64
		k, err = reader.ReadInt64()
		if err != nil {
			return err
		}
		dst[int64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int64) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int64
		k, bytes, err = msgp.ReadInt64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int64) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int64Size
	return size
}

// Int64FromSlice creates a Int64 from a slice.
func Int64FromSlice(s []int64) Int64 {
	if s == nil {
		return nil
	}
	dst := make(Int64, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Int64Sorted is a set of int64s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Int64Sorted map[int64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Int64Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]int64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteInt64(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Int64Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]int64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendInt64(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Int64Sorted) AsSlice() []int64 {
	if s == nil {
		return nil
	}
	dst := make([]int64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Int64Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Int64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int64
		k, err = reader.ReadInt64()
		if err != nil {
			return err
		}
		dst[int64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Int64Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Int64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k int64
		k, bytes, err = msgp.ReadInt64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[int64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Int64Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Int64Size
	return size
}

// Int64SortedFromSlice creates a Int64Sorted from a slice.
func Int64SortedFromSlice(s []int64) Int64Sorted {
	if s == nil {
		return nil
	}
	dst := make(Int64Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint64 is a set of uint64s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Uint64 map[uint64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint64) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteUint64(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint64) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendUint64(bytes, uint64(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Uint64) AsSlice() []uint64 {
	if s == nil {
		return nil
	}
	dst := make([]uint64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint64) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint64
		k, err = reader.ReadUint64()
		if err != nil {
			return err
		}
		dst[uint64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint64) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint64
		k, bytes, err = msgp.ReadUint64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint64) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint64Size
	return size
}

// Uint64FromSlice creates a Uint64 from a slice.
func Uint64FromSlice(s []uint64) Uint64 {
	if s == nil {
		return nil
	}
	dst := make(Uint64, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Uint64Sorted is a set of uint64s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Uint64Sorted map[uint64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Uint64Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]uint64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteUint64(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Uint64Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]uint64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendUint64(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Uint64Sorted) AsSlice() []uint64 {
	if s == nil {
		return nil
	}
	dst := make([]uint64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Uint64Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint64
		k, err = reader.ReadUint64()
		if err != nil {
			return err
		}
		dst[uint64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Uint64Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Uint64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k uint64
		k, bytes, err = msgp.ReadUint64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[uint64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Uint64Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Uint64Size
	return size
}

// Uint64SortedFromSlice creates a Uint64Sorted from a slice.
func Uint64SortedFromSlice(s []uint64) Uint64Sorted {
	if s == nil {
		return nil
	}
	dst := make(Uint64Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Float64 is a set of float64s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Float64 map[float64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Float64) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteFloat(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Float64) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendFloat(bytes, float64(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Float64) AsSlice() []float64 {
	if s == nil {
		return nil
	}
	dst := make([]float64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Float64) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Float64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float64
		k, err = reader.ReadFloat64()
		if err != nil {
			return err
		}
		dst[float64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Float64) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Float64, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float64
		k, bytes, err = msgp.ReadFloat64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[float64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Float64) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Float64Size
	return size
}

// Float64FromSlice creates a Float64 from a slice.
func Float64FromSlice(s []float64) Float64 {
	if s == nil {
		return nil
	}
	dst := make(Float64, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Float64Sorted is a set of float64s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Float64Sorted map[float64]struct{}

// EncodeMsg encodes the message to the writer.
func (s Float64Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]float64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteFloat(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Float64Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]float64, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendFloat(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Float64Sorted) AsSlice() []float64 {
	if s == nil {
		return nil
	}
	dst := make([]float64, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Float64Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Float64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float64
		k, err = reader.ReadFloat64()
		if err != nil {
			return err
		}
		dst[float64(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Float64Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Float64Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float64
		k, bytes, err = msgp.ReadFloat64Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[float64(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Float64Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Float64Size
	return size
}

// Float64SortedFromSlice creates a Float64Sorted from a slice.
func Float64SortedFromSlice(s []float64) Float64Sorted {
	if s == nil {
		return nil
	}
	dst := make(Float64Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Float32 is a set of float32s that will be stored as an array.
// Elements are not sorted and the order of elements is not guaranteed.
type Float32 map[float32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Float32) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	for k := range s {
		err = writer.WriteFloat32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Float32) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	for k := range s {
		bytes = msgp.AppendFloat32(bytes, float32(k))
	}
	return bytes, nil
}

// AsSlice returns the set as a slice.
func (s Float32) AsSlice() []float32 {
	if s == nil {
		return nil
	}
	dst := make([]float32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Float32) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Float32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float32
		k, err = reader.ReadFloat32()
		if err != nil {
			return err
		}
		dst[float32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Float32) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Float32, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float32
		k, bytes, err = msgp.ReadFloat32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[float32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Float32) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Float32Size
	return size
}

// Float32FromSlice creates a Float32 from a slice.
func Float32FromSlice(s []float32) Float32 {
	if s == nil {
		return nil
	}
	dst := make(Float32, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}

// Float32Sorted is a set of float32s that will be stored as an array.
// Elements are sorted and the order of elements is guaranteed.
type Float32Sorted map[float32]struct{}

// EncodeMsg encodes the message to the writer.
func (s Float32Sorted) EncodeMsg(writer *msgp.Writer) error {
	if s == nil {
		return writer.WriteNil()
	}
	err := writer.WriteArrayHeader(uint32(len(s)))
	if err != nil {
		return err
	}
	keys := make([]float32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })

	for _, k := range keys {
		err = writer.WriteFloat32(k)
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalMsg encodes the message to the bytes.
func (s Float32Sorted) MarshalMsg(bytes []byte) ([]byte, error) {
	if s == nil {
		return msgp.AppendNil(bytes), nil
	}
	if len(s) == 0 {
		return msgp.AppendArrayHeader(bytes, 0), nil
	}
	bytes = msgp.AppendArrayHeader(bytes, uint32(len(s)))
	keys := make([]float32, 0, len(s))
	for k := range s {
		keys = append(keys, k)
	}
	sort.Slice(keys, func(i, j int) bool { return keys[i] < keys[j] })
	for _, k := range keys {
		bytes = msgp.AppendFloat32(bytes, k)
	}
	return bytes, nil
}

// AsSlice returns the set as a sorted slice.
func (s Float32Sorted) AsSlice() []float32 {
	if s == nil {
		return nil
	}
	dst := make([]float32, 0, len(s))
	for k := range s {
		dst = append(dst, k)
	}
	sort.Slice(dst, func(i, j int) bool { return dst[i] < dst[j] })
	return dst
}

// DecodeMsg decodes the message from the reader.
func (s *Float32Sorted) DecodeMsg(reader *msgp.Reader) error {
	if reader.IsNil() {
		*s = nil
		return reader.Skip()
	}
	sz, err := reader.ReadArrayHeader()
	if err != nil {
		return err
	}
	dst := *s
	if dst == nil {
		dst = make(Float32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float32
		k, err = reader.ReadFloat32()
		if err != nil {
			return err
		}
		dst[float32(k)] = struct{}{}
	}
	*s = dst
	return nil
}

// UnmarshalMsg decodes the message from the bytes.
func (s *Float32Sorted) UnmarshalMsg(bytes []byte) ([]byte, error) {
	if msgp.IsNil(bytes) {
		*s = nil
		return bytes[msgp.NilSize:], nil
	}
	// Read the array header
	sz, bytes, err := msgp.ReadArrayHeaderBytes(bytes)
	if err != nil {
		return nil, err
	}
	dst := *s
	if dst == nil {
		dst = make(Float32Sorted, sz)
	} else {
		clear(dst)
	}
	for i := uint32(0); i < sz; i++ {
		var k float32
		k, bytes, err = msgp.ReadFloat32Bytes(bytes)
		if err != nil {
			return nil, err
		}
		dst[float32(k)] = struct{}{}
	}
	*s = dst
	return bytes, nil
}

// Msgsize returns the maximum size of the message.
func (s Float32Sorted) Msgsize() int {
	if s == nil {
		return msgp.NilSize
	}
	if len(s) == 0 {
		return msgp.ArrayHeaderSize
	}
	size := msgp.ArrayHeaderSize
	size += len(s) * msgp.Float32Size
	return size
}

// Float32SortedFromSlice creates a Float32Sorted from a slice.
func Float32SortedFromSlice(s []float32) Float32Sorted {
	if s == nil {
		return nil
	}
	dst := make(Float32Sorted, len(s))
	for _, v := range s {
		dst[v] = struct{}{}
	}
	return dst
}
