// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/postgresql/v1/perf_diag.proto

package postgresql

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SessionState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time of collecting statistics on sessions (in the [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format).
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Host of the connected client.
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Server process ID. For client connections, this is a client connection ID.
	Pid int64 `protobuf:"varint,3,opt,name=pid,proto3" json:"pid,omitempty"`
	// Database ID.
	Database string `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
	// User ID.
	User string `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	// Application name on the connected client.
	ApplicationName string `protobuf:"bytes,6,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Time when a given process was started. For client connections, this is the time when the client connected to the server.
	BackendStart *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=backend_start,json=backendStart,proto3" json:"backend_start,omitempty"`
	// Time when a transaction of a given process was started. Returns [NULL] if no transaction is active.
	//
	// If the currently active query is the first of its transaction, the value of this parameter is equal to the value of the [query_start] parameter.
	XactStart *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=xact_start,json=xactStart,proto3" json:"xact_start,omitempty"`
	// Time when the currently active query was started.
	//
	// If the [state] parameter does not take the value [active], the parameter returns the time when the lastest query was started.
	QueryStart *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=query_start,json=queryStart,proto3" json:"query_start,omitempty"`
	// Time when the [state] parameter was last changed.
	StateChange *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=state_change,json=stateChange,proto3" json:"state_change,omitempty"`
	// Type of event for which the backend is waiting. Such an event is called a wait event. A backend refers to the process that maintains the client connection.
	//
	// For the list of wait events, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#WAIT-EVENT-TABLE). If the backend is not waiting for any event, the parameter returns [NULL].
	WaitEventType string `protobuf:"bytes,11,opt,name=wait_event_type,json=waitEventType,proto3" json:"wait_event_type,omitempty"`
	// Wait event name.
	//
	// For the list of such names, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#WAIT-EVENT-ACTIVITY-TABLE). If the backend is not waiting for any event, the parameter returns [NULL].
	WaitEvent string `protobuf:"bytes,12,opt,name=wait_event,json=waitEvent,proto3" json:"wait_event,omitempty"`
	// Current backend state. For the list of possible values, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#MONITORING-PG-STAT-ACTIVITY-VIEW).
	State string `protobuf:"bytes,13,opt,name=state,proto3" json:"state,omitempty"`
	// Text of the most recent query.
	//
	// If the [state] parameter takes the value [active], the parameter shows the currently executing query. For the rest of the states, the parameter shows the last query that was executed. By default, the query text is truncated to 1024 bytes.
	Query string `protobuf:"bytes,14,opt,name=query,proto3" json:"query,omitempty"`
	// Current backend type. For the list of possible values, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/monitoring-stats.html#MONITORING-PG-STAT-ACTIVITY-VIEW).
	BackendType string `protobuf:"bytes,15,opt,name=backend_type,json=backendType,proto3" json:"backend_type,omitempty"`
	// IP address of the connected client.
	//
	// The parameter returns [NULL] in the following cases:
	// - The client is connected via a Unix socket on the server.
	// - A given process is internal (for example, autovacuum).
	ClientAddr string `protobuf:"bytes,16,opt,name=client_addr,json=clientAddr,proto3" json:"client_addr,omitempty"`
	// Host name of the connected client (relevant for IP connections).
	ClientHostname string `protobuf:"bytes,17,opt,name=client_hostname,json=clientHostname,proto3" json:"client_hostname,omitempty"`
	// TCP port number that the client is using for communication with the server.
	//
	// Returns [-1] if the client is connected via a Unix socket on the server. Returns [NULL] if a given process is internal (for example, autovacuum).
	ClientPort int64 `protobuf:"varint,18,opt,name=client_port,json=clientPort,proto3" json:"client_port,omitempty"`
	// Top-level transaction ID, if any.
	BackendXid int64 `protobuf:"varint,19,opt,name=backend_xid,json=backendXid,proto3" json:"backend_xid,omitempty"`
	// Current [xmin horizon].
	BackendXmin int64 `protobuf:"varint,20,opt,name=backend_xmin,json=backendXmin,proto3" json:"backend_xmin,omitempty"`
	// Process IDs that are blocking a given server process ID.
	BlockingPids string `protobuf:"bytes,22,opt,name=blocking_pids,json=blockingPids,proto3" json:"blocking_pids,omitempty"`
	// Query ID.
	QueryId       string `protobuf:"bytes,23,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SessionState) Reset() {
	*x = SessionState{}
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SessionState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionState) ProtoMessage() {}

func (x *SessionState) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionState.ProtoReflect.Descriptor instead.
func (*SessionState) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{0}
}

func (x *SessionState) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *SessionState) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *SessionState) GetPid() int64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *SessionState) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SessionState) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *SessionState) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *SessionState) GetBackendStart() *timestamppb.Timestamp {
	if x != nil {
		return x.BackendStart
	}
	return nil
}

func (x *SessionState) GetXactStart() *timestamppb.Timestamp {
	if x != nil {
		return x.XactStart
	}
	return nil
}

func (x *SessionState) GetQueryStart() *timestamppb.Timestamp {
	if x != nil {
		return x.QueryStart
	}
	return nil
}

func (x *SessionState) GetStateChange() *timestamppb.Timestamp {
	if x != nil {
		return x.StateChange
	}
	return nil
}

func (x *SessionState) GetWaitEventType() string {
	if x != nil {
		return x.WaitEventType
	}
	return ""
}

func (x *SessionState) GetWaitEvent() string {
	if x != nil {
		return x.WaitEvent
	}
	return ""
}

func (x *SessionState) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *SessionState) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SessionState) GetBackendType() string {
	if x != nil {
		return x.BackendType
	}
	return ""
}

func (x *SessionState) GetClientAddr() string {
	if x != nil {
		return x.ClientAddr
	}
	return ""
}

func (x *SessionState) GetClientHostname() string {
	if x != nil {
		return x.ClientHostname
	}
	return ""
}

func (x *SessionState) GetClientPort() int64 {
	if x != nil {
		return x.ClientPort
	}
	return 0
}

func (x *SessionState) GetBackendXid() int64 {
	if x != nil {
		return x.BackendXid
	}
	return 0
}

func (x *SessionState) GetBackendXmin() int64 {
	if x != nil {
		return x.BackendXmin
	}
	return 0
}

func (x *SessionState) GetBlockingPids() string {
	if x != nil {
		return x.BlockingPids
	}
	return ""
}

func (x *SessionState) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

type PrimaryKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Host of the connected client.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// User ID.
	User string `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	// Database ID.
	Database string `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
	// Returns [true] if a query is executed as a top-level SQL statement or if the [pg_stat_statements.track](https://www.postgresql.org/docs/current/pgstatstatements.html#id-1.11.7.41.9) parameter is set to the value [top].
	Toplevel bool `protobuf:"varint,5,opt,name=toplevel,proto3" json:"toplevel,omitempty"`
	// Query ID.
	QueryId string `protobuf:"bytes,6,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	// Query planning ID.
	PlanId        string `protobuf:"bytes,7,opt,name=plan_id,json=planId,proto3" json:"plan_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrimaryKey) Reset() {
	*x = PrimaryKey{}
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrimaryKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryKey) ProtoMessage() {}

func (x *PrimaryKey) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryKey.ProtoReflect.Descriptor instead.
func (*PrimaryKey) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{1}
}

func (x *PrimaryKey) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *PrimaryKey) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *PrimaryKey) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *PrimaryKey) GetToplevel() bool {
	if x != nil {
		return x.Toplevel
	}
	return false
}

func (x *PrimaryKey) GetQueryId() string {
	if x != nil {
		return x.QueryId
	}
	return ""
}

func (x *PrimaryKey) GetPlanId() string {
	if x != nil {
		return x.PlanId
	}
	return ""
}

type QueryStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time of collecting statistics on planning and execution of queries.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Statement text.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Normalized query plan.
	NormalizedPlan string `protobuf:"bytes,3,opt,name=normalized_plan,json=normalizedPlan,proto3" json:"normalized_plan,omitempty"`
	// Example of a query execution plan (without normalization).
	ExamplePlan string `protobuf:"bytes,4,opt,name=example_plan,json=examplePlan,proto3" json:"example_plan,omitempty"`
	// Number of times that a query was planned.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning](https://www.postgresql.org/docs/current/pgstatstatements.html#id-1.11.7.41.9) parameter is enabled.
	Plans int64 `protobuf:"varint,5,opt,name=plans,proto3" json:"plans,omitempty"`
	// Total time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	TotalPlanTime float64 `protobuf:"fixed64,6,opt,name=total_plan_time,json=totalPlanTime,proto3" json:"total_plan_time,omitempty"`
	// Minimum time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MinPlanTime float64 `protobuf:"fixed64,7,opt,name=min_plan_time,json=minPlanTime,proto3" json:"min_plan_time,omitempty"`
	// Maximum time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MaxPlanTime float64 `protobuf:"fixed64,8,opt,name=max_plan_time,json=maxPlanTime,proto3" json:"max_plan_time,omitempty"`
	// Average time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	MeanPlanTime float64 `protobuf:"fixed64,9,opt,name=mean_plan_time,json=meanPlanTime,proto3" json:"mean_plan_time,omitempty"`
	// Population standard deviation of the time taken to plan a query, in milliseconds.
	//
	// The parameter returns a non-zero value if the [pg_stat_statements.track_planning] parameter is enabled.
	StddevPlanTime float64 `protobuf:"fixed64,10,opt,name=stddev_plan_time,json=stddevPlanTime,proto3" json:"stddev_plan_time,omitempty"`
	// Number of times that a query was executed.
	Calls int64 `protobuf:"varint,11,opt,name=calls,proto3" json:"calls,omitempty"`
	// Total time taken to execute a query, in milliseconds.
	TotalTime float64 `protobuf:"fixed64,12,opt,name=total_time,json=totalTime,proto3" json:"total_time,omitempty"` // total_exec_time
	// Minimum time taken to execute a query, in milliseconds.
	MinTime float64 `protobuf:"fixed64,13,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"` // min_exec_time
	// Maximum time taken to execute a query, in milliseconds.
	MaxTime float64 `protobuf:"fixed64,14,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"` // max_exec_time
	// Average time taken to execute a query, in milliseconds.
	MeanTime float64 `protobuf:"fixed64,15,opt,name=mean_time,json=meanTime,proto3" json:"mean_time,omitempty"` // mean_exec_time
	// Population standard deviation of the time taken to execute a query, in milliseconds.
	StddevTime float64 `protobuf:"fixed64,16,opt,name=stddev_time,json=stddevTime,proto3" json:"stddev_time,omitempty"` // stddev_exec_time
	// Number of retrieved or affected rows.
	Rows int64 `protobuf:"varint,17,opt,name=rows,proto3" json:"rows,omitempty"`
	// Number of shared blocks that are hit from cache.
	SharedBlksHit int64 `protobuf:"varint,18,opt,name=shared_blks_hit,json=sharedBlksHit,proto3" json:"shared_blks_hit,omitempty"`
	// Number of read shared blocks.
	SharedBlksRead int64 `protobuf:"varint,19,opt,name=shared_blks_read,json=sharedBlksRead,proto3" json:"shared_blks_read,omitempty"`
	// Number of 'dirtied' shared blocks.
	SharedBlksDirtied int64 `protobuf:"varint,20,opt,name=shared_blks_dirtied,json=sharedBlksDirtied,proto3" json:"shared_blks_dirtied,omitempty"`
	// Number of written shared blocks.
	SharedBlksWritten int64 `protobuf:"varint,21,opt,name=shared_blks_written,json=sharedBlksWritten,proto3" json:"shared_blks_written,omitempty"`
	// Number of local blocks that are hit from cache.
	LocalBlksHit int64 `protobuf:"varint,22,opt,name=local_blks_hit,json=localBlksHit,proto3" json:"local_blks_hit,omitempty"`
	// Number of read local blocks.
	LocalBlksRead int64 `protobuf:"varint,23,opt,name=local_blks_read,json=localBlksRead,proto3" json:"local_blks_read,omitempty"`
	// Number of 'dirtied' local blocks.
	LocalBlksDirtied int64 `protobuf:"varint,24,opt,name=local_blks_dirtied,json=localBlksDirtied,proto3" json:"local_blks_dirtied,omitempty"`
	// Number of written local blocks.
	LocalBlksWritten int64 `protobuf:"varint,25,opt,name=local_blks_written,json=localBlksWritten,proto3" json:"local_blks_written,omitempty"`
	// Number of read temporary blocks.
	TempBlksRead int64 `protobuf:"varint,26,opt,name=temp_blks_read,json=tempBlksRead,proto3" json:"temp_blks_read,omitempty"`
	// Number of written temporary blocks.
	TempBlksWritten int64 `protobuf:"varint,27,opt,name=temp_blks_written,json=tempBlksWritten,proto3" json:"temp_blks_written,omitempty"`
	// Time taken to read data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing](https://www.postgresql.org/docs/current/runtime-config-statistics.html#GUC-TRACK-IO-TIMING) parameter is enabled.
	BlkReadTime float64 `protobuf:"fixed64,28,opt,name=blk_read_time,json=blkReadTime,proto3" json:"blk_read_time,omitempty"`
	// Time taken to record data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	BlkWriteTime float64 `protobuf:"fixed64,29,opt,name=blk_write_time,json=blkWriteTime,proto3" json:"blk_write_time,omitempty"`
	// Time taken to read temporary data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	TempBlkReadTime float64 `protobuf:"fixed64,30,opt,name=temp_blk_read_time,json=tempBlkReadTime,proto3" json:"temp_blk_read_time,omitempty"`
	// Time taken to record temporary data blocks, in milliseconds.
	//
	// The parameter returns a non-zero value if the [track_io_timing] parameter is enabled.
	TempBlkWriteTime float64 `protobuf:"fixed64,31,opt,name=temp_blk_write_time,json=tempBlkWriteTime,proto3" json:"temp_blk_write_time,omitempty"`
	// Number of WAL records generated during a given period.
	WalRecords int64 `protobuf:"varint,32,opt,name=wal_records,json=walRecords,proto3" json:"wal_records,omitempty"`
	// Number of WAL full page images generated during a given period.
	WalFpi int64 `protobuf:"varint,33,opt,name=wal_fpi,json=walFpi,proto3" json:"wal_fpi,omitempty"`
	// Number of WAL logs generated during a given period, in bytes.
	WalBytes int64 `protobuf:"varint,34,opt,name=wal_bytes,json=walBytes,proto3" json:"wal_bytes,omitempty"`
	// Number of JIT-compiled functions.
	JitFunctions int64 `protobuf:"varint,35,opt,name=jit_functions,json=jitFunctions,proto3" json:"jit_functions,omitempty"`
	// Time taken to generate JIT code, in milliseconds.
	JitGenerationTime float64 `protobuf:"fixed64,36,opt,name=jit_generation_time,json=jitGenerationTime,proto3" json:"jit_generation_time,omitempty"`
	// Number of times that functions have been inlined.
	JitInliningCount int64 `protobuf:"varint,37,opt,name=jit_inlining_count,json=jitInliningCount,proto3" json:"jit_inlining_count,omitempty"`
	// Time taken to inline functions, in milliseconds.
	JitInliningTime float64 `protobuf:"fixed64,38,opt,name=jit_inlining_time,json=jitInliningTime,proto3" json:"jit_inlining_time,omitempty"`
	// Number of times that a query was optimized.
	JitOptimizationCount int64 `protobuf:"varint,39,opt,name=jit_optimization_count,json=jitOptimizationCount,proto3" json:"jit_optimization_count,omitempty"`
	// Time taken to optimize a query, in milliseconds.
	JitOptimizationTime float64 `protobuf:"fixed64,40,opt,name=jit_optimization_time,json=jitOptimizationTime,proto3" json:"jit_optimization_time,omitempty"`
	// Number of times that code was emitted.
	JitEmissionCount int64 `protobuf:"varint,41,opt,name=jit_emission_count,json=jitEmissionCount,proto3" json:"jit_emission_count,omitempty"`
	// Time taken to emit code.
	JitEmissionTime float64 `protobuf:"fixed64,42,opt,name=jit_emission_time,json=jitEmissionTime,proto3" json:"jit_emission_time,omitempty"`
	// Cost of receiving a response to a query before the first row of the response is issued.
	StartupCost int64 `protobuf:"varint,43,opt,name=startup_cost,json=startupCost,proto3" json:"startup_cost,omitempty"`
	// Cost of receiving a response to a query when all the rows of the response are issued.
	TotalCost int64 `protobuf:"varint,44,opt,name=total_cost,json=totalCost,proto3" json:"total_cost,omitempty"`
	// Expected number of rows that a given plan node should issue.
	PlanRows int64 `protobuf:"varint,45,opt,name=plan_rows,json=planRows,proto3" json:"plan_rows,omitempty"`
	// Expected average size of rows that a given plan node should issue.
	PlanWidth int64 `protobuf:"varint,46,opt,name=plan_width,json=planWidth,proto3" json:"plan_width,omitempty"`
	// Number of bytes that the filesystem layer has read.
	Reads int64 `protobuf:"varint,47,opt,name=reads,proto3" json:"reads,omitempty"`
	// Number of bytes that the filesystem layer has written.
	Writes int64 `protobuf:"varint,48,opt,name=writes,proto3" json:"writes,omitempty"`
	// User CPU time used.
	UserTime float64 `protobuf:"fixed64,49,opt,name=user_time,json=userTime,proto3" json:"user_time,omitempty"`
	// System CPU time used.
	SystemTime    float64 `protobuf:"fixed64,50,opt,name=system_time,json=systemTime,proto3" json:"system_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryStats) Reset() {
	*x = QueryStats{}
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStats) ProtoMessage() {}

func (x *QueryStats) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStats.ProtoReflect.Descriptor instead.
func (*QueryStats) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{2}
}

func (x *QueryStats) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *QueryStats) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *QueryStats) GetNormalizedPlan() string {
	if x != nil {
		return x.NormalizedPlan
	}
	return ""
}

func (x *QueryStats) GetExamplePlan() string {
	if x != nil {
		return x.ExamplePlan
	}
	return ""
}

func (x *QueryStats) GetPlans() int64 {
	if x != nil {
		return x.Plans
	}
	return 0
}

func (x *QueryStats) GetTotalPlanTime() float64 {
	if x != nil {
		return x.TotalPlanTime
	}
	return 0
}

func (x *QueryStats) GetMinPlanTime() float64 {
	if x != nil {
		return x.MinPlanTime
	}
	return 0
}

func (x *QueryStats) GetMaxPlanTime() float64 {
	if x != nil {
		return x.MaxPlanTime
	}
	return 0
}

func (x *QueryStats) GetMeanPlanTime() float64 {
	if x != nil {
		return x.MeanPlanTime
	}
	return 0
}

func (x *QueryStats) GetStddevPlanTime() float64 {
	if x != nil {
		return x.StddevPlanTime
	}
	return 0
}

func (x *QueryStats) GetCalls() int64 {
	if x != nil {
		return x.Calls
	}
	return 0
}

func (x *QueryStats) GetTotalTime() float64 {
	if x != nil {
		return x.TotalTime
	}
	return 0
}

func (x *QueryStats) GetMinTime() float64 {
	if x != nil {
		return x.MinTime
	}
	return 0
}

func (x *QueryStats) GetMaxTime() float64 {
	if x != nil {
		return x.MaxTime
	}
	return 0
}

func (x *QueryStats) GetMeanTime() float64 {
	if x != nil {
		return x.MeanTime
	}
	return 0
}

func (x *QueryStats) GetStddevTime() float64 {
	if x != nil {
		return x.StddevTime
	}
	return 0
}

func (x *QueryStats) GetRows() int64 {
	if x != nil {
		return x.Rows
	}
	return 0
}

func (x *QueryStats) GetSharedBlksHit() int64 {
	if x != nil {
		return x.SharedBlksHit
	}
	return 0
}

func (x *QueryStats) GetSharedBlksRead() int64 {
	if x != nil {
		return x.SharedBlksRead
	}
	return 0
}

func (x *QueryStats) GetSharedBlksDirtied() int64 {
	if x != nil {
		return x.SharedBlksDirtied
	}
	return 0
}

func (x *QueryStats) GetSharedBlksWritten() int64 {
	if x != nil {
		return x.SharedBlksWritten
	}
	return 0
}

func (x *QueryStats) GetLocalBlksHit() int64 {
	if x != nil {
		return x.LocalBlksHit
	}
	return 0
}

func (x *QueryStats) GetLocalBlksRead() int64 {
	if x != nil {
		return x.LocalBlksRead
	}
	return 0
}

func (x *QueryStats) GetLocalBlksDirtied() int64 {
	if x != nil {
		return x.LocalBlksDirtied
	}
	return 0
}

func (x *QueryStats) GetLocalBlksWritten() int64 {
	if x != nil {
		return x.LocalBlksWritten
	}
	return 0
}

func (x *QueryStats) GetTempBlksRead() int64 {
	if x != nil {
		return x.TempBlksRead
	}
	return 0
}

func (x *QueryStats) GetTempBlksWritten() int64 {
	if x != nil {
		return x.TempBlksWritten
	}
	return 0
}

func (x *QueryStats) GetBlkReadTime() float64 {
	if x != nil {
		return x.BlkReadTime
	}
	return 0
}

func (x *QueryStats) GetBlkWriteTime() float64 {
	if x != nil {
		return x.BlkWriteTime
	}
	return 0
}

func (x *QueryStats) GetTempBlkReadTime() float64 {
	if x != nil {
		return x.TempBlkReadTime
	}
	return 0
}

func (x *QueryStats) GetTempBlkWriteTime() float64 {
	if x != nil {
		return x.TempBlkWriteTime
	}
	return 0
}

func (x *QueryStats) GetWalRecords() int64 {
	if x != nil {
		return x.WalRecords
	}
	return 0
}

func (x *QueryStats) GetWalFpi() int64 {
	if x != nil {
		return x.WalFpi
	}
	return 0
}

func (x *QueryStats) GetWalBytes() int64 {
	if x != nil {
		return x.WalBytes
	}
	return 0
}

func (x *QueryStats) GetJitFunctions() int64 {
	if x != nil {
		return x.JitFunctions
	}
	return 0
}

func (x *QueryStats) GetJitGenerationTime() float64 {
	if x != nil {
		return x.JitGenerationTime
	}
	return 0
}

func (x *QueryStats) GetJitInliningCount() int64 {
	if x != nil {
		return x.JitInliningCount
	}
	return 0
}

func (x *QueryStats) GetJitInliningTime() float64 {
	if x != nil {
		return x.JitInliningTime
	}
	return 0
}

func (x *QueryStats) GetJitOptimizationCount() int64 {
	if x != nil {
		return x.JitOptimizationCount
	}
	return 0
}

func (x *QueryStats) GetJitOptimizationTime() float64 {
	if x != nil {
		return x.JitOptimizationTime
	}
	return 0
}

func (x *QueryStats) GetJitEmissionCount() int64 {
	if x != nil {
		return x.JitEmissionCount
	}
	return 0
}

func (x *QueryStats) GetJitEmissionTime() float64 {
	if x != nil {
		return x.JitEmissionTime
	}
	return 0
}

func (x *QueryStats) GetStartupCost() int64 {
	if x != nil {
		return x.StartupCost
	}
	return 0
}

func (x *QueryStats) GetTotalCost() int64 {
	if x != nil {
		return x.TotalCost
	}
	return 0
}

func (x *QueryStats) GetPlanRows() int64 {
	if x != nil {
		return x.PlanRows
	}
	return 0
}

func (x *QueryStats) GetPlanWidth() int64 {
	if x != nil {
		return x.PlanWidth
	}
	return 0
}

func (x *QueryStats) GetReads() int64 {
	if x != nil {
		return x.Reads
	}
	return 0
}

func (x *QueryStats) GetWrites() int64 {
	if x != nil {
		return x.Writes
	}
	return 0
}

func (x *QueryStats) GetUserTime() float64 {
	if x != nil {
		return x.UserTime
	}
	return 0
}

func (x *QueryStats) GetSystemTime() float64 {
	if x != nil {
		return x.SystemTime
	}
	return 0
}

type QueryStatement struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Primary keys in tables with the statistics on planning and execution of queries.
	Key *PrimaryKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Statistics on planning and execution of queries.
	Stats         *QueryStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryStatement) Reset() {
	*x = QueryStatement{}
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryStatement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStatement) ProtoMessage() {}

func (x *QueryStatement) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStatement.ProtoReflect.Descriptor instead.
func (*QueryStatement) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP(), []int{3}
}

func (x *QueryStatement) GetKey() *PrimaryKey {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *QueryStatement) GetStats() *QueryStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

var File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc = "" +
	"\n" +
	".yandex/cloud/mdb/postgresql/v1/perf_diag.proto\x12\x1eyandex.cloud.mdb.postgresql.v1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xc2\x06\n" +
	"\fSessionState\x12.\n" +
	"\x04time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04time\x12\x12\n" +
	"\x04host\x18\x02 \x01(\tR\x04host\x12\x10\n" +
	"\x03pid\x18\x03 \x01(\x03R\x03pid\x12\x1a\n" +
	"\bdatabase\x18\x04 \x01(\tR\bdatabase\x12\x12\n" +
	"\x04user\x18\x05 \x01(\tR\x04user\x12)\n" +
	"\x10application_name\x18\x06 \x01(\tR\x0fapplicationName\x12?\n" +
	"\rbackend_start\x18\a \x01(\v2\x1a.google.protobuf.TimestampR\fbackendStart\x129\n" +
	"\n" +
	"xact_start\x18\b \x01(\v2\x1a.google.protobuf.TimestampR\txactStart\x12;\n" +
	"\vquery_start\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"queryStart\x12=\n" +
	"\fstate_change\x18\n" +
	" \x01(\v2\x1a.google.protobuf.TimestampR\vstateChange\x12&\n" +
	"\x0fwait_event_type\x18\v \x01(\tR\rwaitEventType\x12\x1d\n" +
	"\n" +
	"wait_event\x18\f \x01(\tR\twaitEvent\x12\x14\n" +
	"\x05state\x18\r \x01(\tR\x05state\x12\x14\n" +
	"\x05query\x18\x0e \x01(\tR\x05query\x12!\n" +
	"\fbackend_type\x18\x0f \x01(\tR\vbackendType\x12\x1f\n" +
	"\vclient_addr\x18\x10 \x01(\tR\n" +
	"clientAddr\x12'\n" +
	"\x0fclient_hostname\x18\x11 \x01(\tR\x0eclientHostname\x12\x1f\n" +
	"\vclient_port\x18\x12 \x01(\x03R\n" +
	"clientPort\x12\x1f\n" +
	"\vbackend_xid\x18\x13 \x01(\x03R\n" +
	"backendXid\x12!\n" +
	"\fbackend_xmin\x18\x14 \x01(\x03R\vbackendXmin\x12#\n" +
	"\rblocking_pids\x18\x16 \x01(\tR\fblockingPids\x12\x19\n" +
	"\bquery_id\x18\x17 \x01(\tR\aqueryIdJ\x04\b\x15\x10\x16\"\xa6\x01\n" +
	"\n" +
	"PrimaryKey\x12\x12\n" +
	"\x04host\x18\x01 \x01(\tR\x04host\x12\x12\n" +
	"\x04user\x18\x02 \x01(\tR\x04user\x12\x1a\n" +
	"\bdatabase\x18\x04 \x01(\tR\bdatabase\x12\x1a\n" +
	"\btoplevel\x18\x05 \x01(\bR\btoplevel\x12\x19\n" +
	"\bquery_id\x18\x06 \x01(\tR\aqueryId\x12\x17\n" +
	"\aplan_id\x18\a \x01(\tR\x06planIdJ\x04\b\x03\x10\x04\"\xb9\x0e\n" +
	"\n" +
	"QueryStats\x12.\n" +
	"\x04time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04time\x12\x14\n" +
	"\x05query\x18\x02 \x01(\tR\x05query\x12'\n" +
	"\x0fnormalized_plan\x18\x03 \x01(\tR\x0enormalizedPlan\x12!\n" +
	"\fexample_plan\x18\x04 \x01(\tR\vexamplePlan\x12\x14\n" +
	"\x05plans\x18\x05 \x01(\x03R\x05plans\x12&\n" +
	"\x0ftotal_plan_time\x18\x06 \x01(\x01R\rtotalPlanTime\x12\"\n" +
	"\rmin_plan_time\x18\a \x01(\x01R\vminPlanTime\x12\"\n" +
	"\rmax_plan_time\x18\b \x01(\x01R\vmaxPlanTime\x12$\n" +
	"\x0emean_plan_time\x18\t \x01(\x01R\fmeanPlanTime\x12(\n" +
	"\x10stddev_plan_time\x18\n" +
	" \x01(\x01R\x0estddevPlanTime\x12\x14\n" +
	"\x05calls\x18\v \x01(\x03R\x05calls\x12\x1d\n" +
	"\n" +
	"total_time\x18\f \x01(\x01R\ttotalTime\x12\x19\n" +
	"\bmin_time\x18\r \x01(\x01R\aminTime\x12\x19\n" +
	"\bmax_time\x18\x0e \x01(\x01R\amaxTime\x12\x1b\n" +
	"\tmean_time\x18\x0f \x01(\x01R\bmeanTime\x12\x1f\n" +
	"\vstddev_time\x18\x10 \x01(\x01R\n" +
	"stddevTime\x12\x12\n" +
	"\x04rows\x18\x11 \x01(\x03R\x04rows\x12&\n" +
	"\x0fshared_blks_hit\x18\x12 \x01(\x03R\rsharedBlksHit\x12(\n" +
	"\x10shared_blks_read\x18\x13 \x01(\x03R\x0esharedBlksRead\x12.\n" +
	"\x13shared_blks_dirtied\x18\x14 \x01(\x03R\x11sharedBlksDirtied\x12.\n" +
	"\x13shared_blks_written\x18\x15 \x01(\x03R\x11sharedBlksWritten\x12$\n" +
	"\x0elocal_blks_hit\x18\x16 \x01(\x03R\flocalBlksHit\x12&\n" +
	"\x0flocal_blks_read\x18\x17 \x01(\x03R\rlocalBlksRead\x12,\n" +
	"\x12local_blks_dirtied\x18\x18 \x01(\x03R\x10localBlksDirtied\x12,\n" +
	"\x12local_blks_written\x18\x19 \x01(\x03R\x10localBlksWritten\x12$\n" +
	"\x0etemp_blks_read\x18\x1a \x01(\x03R\ftempBlksRead\x12*\n" +
	"\x11temp_blks_written\x18\x1b \x01(\x03R\x0ftempBlksWritten\x12\"\n" +
	"\rblk_read_time\x18\x1c \x01(\x01R\vblkReadTime\x12$\n" +
	"\x0eblk_write_time\x18\x1d \x01(\x01R\fblkWriteTime\x12+\n" +
	"\x12temp_blk_read_time\x18\x1e \x01(\x01R\x0ftempBlkReadTime\x12-\n" +
	"\x13temp_blk_write_time\x18\x1f \x01(\x01R\x10tempBlkWriteTime\x12\x1f\n" +
	"\vwal_records\x18  \x01(\x03R\n" +
	"walRecords\x12\x17\n" +
	"\awal_fpi\x18! \x01(\x03R\x06walFpi\x12\x1b\n" +
	"\twal_bytes\x18\" \x01(\x03R\bwalBytes\x12#\n" +
	"\rjit_functions\x18# \x01(\x03R\fjitFunctions\x12.\n" +
	"\x13jit_generation_time\x18$ \x01(\x01R\x11jitGenerationTime\x12,\n" +
	"\x12jit_inlining_count\x18% \x01(\x03R\x10jitInliningCount\x12*\n" +
	"\x11jit_inlining_time\x18& \x01(\x01R\x0fjitInliningTime\x124\n" +
	"\x16jit_optimization_count\x18' \x01(\x03R\x14jitOptimizationCount\x122\n" +
	"\x15jit_optimization_time\x18( \x01(\x01R\x13jitOptimizationTime\x12,\n" +
	"\x12jit_emission_count\x18) \x01(\x03R\x10jitEmissionCount\x12*\n" +
	"\x11jit_emission_time\x18* \x01(\x01R\x0fjitEmissionTime\x12!\n" +
	"\fstartup_cost\x18+ \x01(\x03R\vstartupCost\x12\x1d\n" +
	"\n" +
	"total_cost\x18, \x01(\x03R\ttotalCost\x12\x1b\n" +
	"\tplan_rows\x18- \x01(\x03R\bplanRows\x12\x1d\n" +
	"\n" +
	"plan_width\x18. \x01(\x03R\tplanWidth\x12\x14\n" +
	"\x05reads\x18/ \x01(\x03R\x05reads\x12\x16\n" +
	"\x06writes\x180 \x01(\x03R\x06writes\x12\x1b\n" +
	"\tuser_time\x181 \x01(\x01R\buserTime\x12\x1f\n" +
	"\vsystem_time\x182 \x01(\x01R\n" +
	"systemTime\"\x90\x01\n" +
	"\x0eQueryStatement\x12<\n" +
	"\x03key\x18\x01 \x01(\v2*.yandex.cloud.mdb.postgresql.v1.PrimaryKeyR\x03key\x12@\n" +
	"\x05stats\x18\x02 \x01(\v2*.yandex.cloud.mdb.postgresql.v1.QueryStatsR\x05statsBs\n" +
	"\"yandex.cloud.api.mdb.postgresql.v1ZMgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1;postgresqlb\x06proto3"

var (
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc), len(file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDescData
}

var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes = []any{
	(*SessionState)(nil),          // 0: yandex.cloud.mdb.postgresql.v1.SessionState
	(*PrimaryKey)(nil),            // 1: yandex.cloud.mdb.postgresql.v1.PrimaryKey
	(*QueryStats)(nil),            // 2: yandex.cloud.mdb.postgresql.v1.QueryStats
	(*QueryStatement)(nil),        // 3: yandex.cloud.mdb.postgresql.v1.QueryStatement
	(*timestamppb.Timestamp)(nil), // 4: google.protobuf.Timestamp
}
var file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs = []int32{
	4, // 0: yandex.cloud.mdb.postgresql.v1.SessionState.time:type_name -> google.protobuf.Timestamp
	4, // 1: yandex.cloud.mdb.postgresql.v1.SessionState.backend_start:type_name -> google.protobuf.Timestamp
	4, // 2: yandex.cloud.mdb.postgresql.v1.SessionState.xact_start:type_name -> google.protobuf.Timestamp
	4, // 3: yandex.cloud.mdb.postgresql.v1.SessionState.query_start:type_name -> google.protobuf.Timestamp
	4, // 4: yandex.cloud.mdb.postgresql.v1.SessionState.state_change:type_name -> google.protobuf.Timestamp
	4, // 5: yandex.cloud.mdb.postgresql.v1.QueryStats.time:type_name -> google.protobuf.Timestamp
	1, // 6: yandex.cloud.mdb.postgresql.v1.QueryStatement.key:type_name -> yandex.cloud.mdb.postgresql.v1.PrimaryKey
	2, // 7: yandex.cloud.mdb.postgresql.v1.QueryStatement.stats:type_name -> yandex.cloud.mdb.postgresql.v1.QueryStats
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_init() }
func file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_init() {
	if File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc), len(file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_postgresql_v1_perf_diag_proto = out.File
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_goTypes = nil
	file_yandex_cloud_mdb_postgresql_v1_perf_diag_proto_depIdxs = nil
}
