// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSpan_Event(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan_Event() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigSpan_Event()
				CopyOrigSpan_Event(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigSpan_Event(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigSpan_EventUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigSpan_Event()
	UnmarshalJSONOrigSpan_Event(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigSpan_Event(), dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan_Event(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan_Event() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigSpan_Event(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigSpan_Event()
				UnmarshalJSONOrigSpan_Event(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigSpan_Event(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigSpan_EventFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSpan_Event() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigSpan_Event()
			require.Error(t, UnmarshalProtoOrigSpan_Event(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSpan_EventUnknown(t *testing.T) {
	dest := NewOrigSpan_Event()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigSpan_Event(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigSpan_Event(), dest)
}

func TestMarshalAndUnmarshalProtoOrigSpan_Event(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan_Event() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigSpan_Event(src))
				gotSize := MarshalProtoOrigSpan_Event(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigSpan_Event()
				require.NoError(t, UnmarshalProtoOrigSpan_Event(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigSpan_Event(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSpan_Event(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan_Event() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSpan_Event(src))
			gotSize := MarshalProtoOrigSpan_Event(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.Span_Event{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigSpan_Event()
			require.NoError(t, UnmarshalProtoOrigSpan_Event(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSpan_Event() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"TimeUnixNano/wrong_wire_type":           {0xc},
		"TimeUnixNano/missing_value":             {0x9},
		"Name/wrong_wire_type":                   {0x14},
		"Name/missing_value":                     {0x12},
		"Attributes/wrong_wire_type":             {0x1c},
		"Attributes/missing_value":               {0x1a},
		"DroppedAttributesCount/wrong_wire_type": {0x24},
		"DroppedAttributesCount/missing_value":   {0x20},
	}
}

func genTestEncodingValuesSpan_Event() map[string]*otlptrace.Span_Event {
	return map[string]*otlptrace.Span_Event{
		"empty":                       NewOrigSpan_Event(),
		"TimeUnixNano/test":           {TimeUnixNano: uint64(13)},
		"Name/test":                   {Name: "test_name"},
		"Attributes/default_and_test": {Attributes: []otlpcommon.KeyValue{{}, *GenTestOrigKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
	}
}
