// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyTracesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewTracesRequest()
				CopyTracesRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyTracesRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyTracesRequestSlice(t *testing.T) {
	src := []TracesRequest{}
	dest := []TracesRequest{}
	// Test CopyTo empty
	dest = CopyTracesRequestSlice(dest, src)
	assert.Equal(t, []TracesRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestTracesRequestSlice()
	dest = CopyTracesRequestSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTracesRequestSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTracesRequestSlice(dest, []TracesRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTracesRequestSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestSlice(), dest)
}

func TestCopyTracesRequestPtrSlice(t *testing.T) {
	src := []*TracesRequest{}
	dest := []*TracesRequest{}
	// Test CopyTo empty
	dest = CopyTracesRequestPtrSlice(dest, src)
	assert.Equal(t, []*TracesRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestTracesRequestPtrSlice()
	dest = CopyTracesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTracesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTracesRequestPtrSlice(dest, []*TracesRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTracesRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONTracesRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewTracesRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewTracesRequest(), dest)
}

func TestMarshalAndUnmarshalJSONTracesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewTracesRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteTracesRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoTracesRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesTracesRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewTracesRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoTracesRequestUnknown(t *testing.T) {
	dest := NewTracesRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewTracesRequest(), dest)
}

func TestMarshalAndUnmarshalProtoTracesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewTracesRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteTracesRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufTracesRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewTracesRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesTracesRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"RequestContext/wrong_wire_type": {0x14},
		"RequestContext/missing_value":   {0x12},
		"TracesData/wrong_wire_type":     {0x1c},
		"TracesData/missing_value":       {0x1a},
		"FormatVersion/wrong_wire_type":  {0xc},
		"FormatVersion/missing_value":    {0xd},
	}
}

func genTestEncodingValuesTracesRequest() map[string]*TracesRequest {
	return map[string]*TracesRequest{
		"empty":               NewTracesRequest(),
		"RequestContext/test": {RequestContext: GenTestRequestContext()},
		"TracesData/test":     {TracesData: *GenTestTracesData()},
		"FormatVersion/test":  {FormatVersion: uint32(13)},
	}
}
