// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestExponentialHistogramDataPointBuckets_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogramDataPointBuckets()
	dest := NewExponentialHistogramDataPointBuckets()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), ms)
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.MoveTo(newExponentialHistogramDataPointBuckets(internal.NewExponentialHistogramDataPointBuckets(), sharedState))
	})
	assert.Panics(t, func() {
		newExponentialHistogramDataPointBuckets(internal.NewExponentialHistogramDataPointBuckets(), sharedState).MoveTo(dest)
	})
}

func TestExponentialHistogramDataPointBuckets_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	orig := NewExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		ms.CopyTo(newExponentialHistogramDataPointBuckets(internal.NewExponentialHistogramDataPointBuckets(), sharedState))
	})
}

func TestExponentialHistogramDataPointBuckets_Offset(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, int32(0), ms.Offset())
	ms.SetOffset(int32(13))
	assert.Equal(t, int32(13), ms.Offset())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExponentialHistogramDataPointBuckets(internal.NewExponentialHistogramDataPointBuckets(), sharedState).SetOffset(int32(13))
	})
}

func TestExponentialHistogramDataPointBuckets_BucketCounts(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, pcommon.NewUInt64Slice(), ms.BucketCounts())
	ms.orig.BucketCounts = internal.GenTestUint64Slice()
	assert.Equal(t, pcommon.UInt64Slice(internal.GenTestUInt64SliceWrapper()), ms.BucketCounts())
}

func generateTestExponentialHistogramDataPointBuckets() ExponentialHistogramDataPointBuckets {
	return newExponentialHistogramDataPointBuckets(internal.GenTestExponentialHistogramDataPointBuckets(), internal.NewState())
}
