// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigLink()
				CopyOrigLink(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigLink(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigLinkUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigLink()
	UnmarshalJSONOrigLink(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigLink(), dest)
}

func TestMarshalAndUnmarshalJSONOrigLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigLink(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigLink()
				UnmarshalJSONOrigLink(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigLinkFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLink() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigLink()
			require.Error(t, UnmarshalProtoOrigLink(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigLinkUnknown(t *testing.T) {
	dest := NewOrigLink()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigLink(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigLink(), dest)
}

func TestMarshalAndUnmarshalProtoOrigLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigLink(src))
				gotSize := MarshalProtoOrigLink(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigLink()
				require.NoError(t, UnmarshalProtoOrigLink(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigLink(src))
			gotSize := MarshalProtoOrigLink(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Link{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigLink()
			require.NoError(t, UnmarshalProtoOrigLink(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLink() map[string][]byte {
	return map[string][]byte{
		"invalid_field":           {0x02},
		"TraceId/wrong_wire_type": {0xc},
		"TraceId/missing_value":   {0xa},
		"SpanId/wrong_wire_type":  {0x14},
		"SpanId/missing_value":    {0x12},
	}
}

func genTestEncodingValuesLink() map[string]*otlpprofiles.Link {
	return map[string]*otlpprofiles.Link{
		"empty":        NewOrigLink(),
		"TraceId/test": {TraceId: *GenTestOrigTraceID()},
		"SpanId/test":  {SpanId: *GenTestOrigSpanID()},
	}
}
