// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestLink_MoveTo(t *testing.T) {
	ms := generateTestLink()
	dest := NewLink()
	ms.MoveTo(dest)
	assert.Equal(t, NewLink(), ms)
	assert.Equal(t, generateTestLink(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestLink(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newLink(internal.NewLink(), sharedState)) })
	assert.Panics(t, func() { newLink(internal.NewLink(), sharedState).MoveTo(dest) })
}

func TestLink_CopyTo(t *testing.T) {
	ms := NewLink()
	orig := NewLink()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestLink()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newLink(internal.NewLink(), sharedState)) })
}

func TestLink_TraceID(t *testing.T) {
	ms := NewLink()
	assert.Equal(t, pcommon.TraceID(internal.TraceID([16]byte{})), ms.TraceID())
	testValTraceID := pcommon.TraceID(internal.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetTraceID(testValTraceID)
	assert.Equal(t, testValTraceID, ms.TraceID())
}

func TestLink_SpanID(t *testing.T) {
	ms := NewLink()
	assert.Equal(t, pcommon.SpanID(internal.SpanID([8]byte{})), ms.SpanID())
	testValSpanID := pcommon.SpanID(internal.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetSpanID(testValSpanID)
	assert.Equal(t, testValSpanID, ms.SpanID())
}

func generateTestLink() Link {
	return newLink(internal.GenTestLink(), internal.NewState())
}
