---
date: 2025-03-12
slug: goreleaser-v2.8
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.8

Happy March!
Another release is here with several improvements across the board.

<!-- more -->

Let's dig into some of the news!

## New Package Repository Features

<!-- md:pro -->

The Cloudsmith integration now supports multiple distributions.

[Learn more][cloudsmith].

## Publish to NPM

<!-- md:pro -->

This is a long asked feature: publish your project to NPM.

NPM is great because pretty much every developer has it installed, and some
enjoy installing binaries through it.

GoReleaser can generate the package for you, which will, upon install, download
and extract the right archive from the release.

You can [read more about it here][npm].

## Native macOS DMG signing and notarizing

<!-- md:pro -->

GoReleaser Pro and OSS can already sign and notarize binaries, but DMGs and
`.app`s are a whole different ordeal.

This version adds support to it, and you can [read more about it here][notary].

## New templating features

<!-- md:pro -->

- `.IsMerging`: will be `true` if its the final step of a
  [partial build][partial];
- `.IsRelease`: will be `true` if its not a [snapshot][snapshot] nor a
  [nightly build][nightly];
- `reReplaceAll`: allows to use regular expressions to replace parts of the
  string. More on that below!

You can learn more about it [here][templates].

## AUR and KO Improvements

Both AUR and AUR Sources now support adding custom install scripts.

Also, you can now use `aurs.disable` and `aur_sources.disable` to conditionally
disable a particular configuration.

Similarly, you can now also use `kos.disable`.

Read more about it [here][aur], [here][aursources], and [here][ko].

## Changelog improvements

Historically, when using the `git` changeloger, we didn't had many options.
We would use the `oneline` format, and split on the first space, so we got both
the commit SHA and the message.

In this version, we started using a custom format, which allowed us to:

- properly handle commit abbrevs when using custom formats
- customize format when using `use: git`, including adding author name and email
- properly handle filters when the format doesn't have a leading SHA

With the usage of the newly added `reReplaceAll` function, you may also do
things like this:

```yaml title=".goreleaser.yaml"
changelog:
  format: '{{ reReplaceAll "(.*) \\(#(.*)\\)" .Message "$1 [#$1](https://my.custom.tracker/issues/$2)" }}'
```

Which I think is pretty neat. :)

[Read more about it here][changelog].

## Deprecations

To make options more alike, `archives.builds`, `nfpms.builds`, and
`snaps.builds` have been renamed to `archives.ids`, `nfpms.ids`, and
`snaps.ids`.

[All active deprecation warnings][deprecations].

## Other smaller changes

- **pro**: `goreleaser healthcheck` will now properly check MSI and DMG
  dependencies;
- **pro**: `goreleaser r --nightly` will now work on a repository with no tags;
- **pro**: DMG on macOS will now use ULMO instead of UDBZ - this should yield
  smaller `.dmg` files. Compatible with macOS 10.15+ (from 2019);
- **archive**: when running the pipeline on Windows, set the binaries as
  executable inside the archives;
- **docker**: retry manifest push if digest don't match - this seems to be an
  out-of-sync issue with the registry;
- **nfpm**: properly handle skips of single configurations;

## Other news

- GoReleaser now has ~14.4k stars and 423 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can install or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries from GitHub:

[:fontawesome-solid-download: Install][install]{ .md-button .md-button--primary }
[:fontawesome-brands-github: v2.8.0 (OSS)][oss-rel]{ .md-button }
[:fontawesome-brands-github: v2.8.0 (Pro)][pro-rel]{ .md-button }

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also sponsor the project, or get a GoReleaser Pro license.

[:material-professional-hexagon: Get the Pro license][pro]{ .md-button .md-button--primary }
[:simple-githubsponsors: Sponsor the project][sponsor]{ .md-button }

[sponsor]: https://goreleaser.com/sponsors
[pro]: https://goreleaser.com/pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.8.0
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.8.0
[discord]: https://goreleaser.com/discord
[npm]: https://goreleaser.com/customization/npm
[ko]: https://goreleaser.com/customization/ko
[aur]: https://goreleaser.com/customization/aur
[aursources]: https://goreleaser.com/customization/aursources
[cloudsmith]: https://goreleaser.com/customization/cloudsmith
[notary]: https://goreleaser.com/customization/notarize/
[changelog]: https://goreleaser.com/customization/changelog
[deprecations]: https://goreleaser.com/deprecations
[partial]: https://goreleaser.com/customization/partial/
[nightly]: https://goreleaser.com/customization/nightlies/
[snapshot]: https://goreleaser.com/customization/snapshots/
[templates]: https://goreleaser.com/customization/templates/
