/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.tools.I18n;

public class ChangeMembersCommand
extends Command {
    private final Relation relation;
    private final List<RelationMember> cmdMembers;

    public ChangeMembersCommand(DataSet data, Relation relation, List<RelationMember> newMembers) {
        super(data);
        this.relation = Objects.requireNonNull(relation, "relation");
        this.cmdMembers = Objects.requireNonNull(newMembers, "newMembers");
    }

    public ChangeMembersCommand(Relation relation, List<RelationMember> newMembers) {
        this(relation.getDataSet(), relation, newMembers);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.relation.setMembers(this.cmdMembers);
        this.relation.setModified(true);
        return true;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change members of {0}", this.relation.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.relation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relation, this.cmdMembers);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChangeMembersCommand that = (ChangeMembersCommand)obj;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.cmdMembers, that.cmdMembers);
    }
}

