# Contributing to Plakar

Thank you for your interest in contributing to Plakar! We welcome contributions of all kinds, including new features, bug fixes, documentation improvements, and more. Please take a moment to read through this guide to understand our contribution process and how to get started.

## How to Contribute

### 1. Reporting Bugs and Issues
If you've found a bug or have a suggestion for improvement, please [open an issue](https://github.com/plakar/plakar/issues) on GitHub. Include as much detail as possible, such as:

- A description of the problem or suggestion.
- Steps to reproduce the issue (if applicable).
- Relevant logs or error messages.
- Any other context that would help us understand the problem.

### 2. Suggesting Features
We are always looking for ways to make Plakar better! If you have a feature request, feel free to open an issue with a detailed explanation of the proposed feature, its use cases, and potential benefits.

### 3. Submitting Changes
Before starting any work, it's a good idea to discuss your idea with the maintainers by opening an issue or commenting on an existing one. This helps ensure your work aligns with project goals and saves time for everyone involved.

#### Steps to Submit Changes:
1. **Fork the Repository**  
   Create a personal fork of the repository on GitHub to work in.

2. **Create a Feature Branch**  
   Use descriptive names for your branches, such as `fix-bug-issue123` or `feature-new-backup-strategy`.

3. **Write Clear, Concise Commit Messages**  
   Each commit message should clearly describe what change was made and why. Use the present tense, e.g., "Fix issue with backup scheduler."

4. **Follow the Coding Style**  
   - Adhere to the project’s code style and formatting.
   - Ensure your code is clear, maintainable, and well-documented.

5. **Run Tests and Linters**  
   - Make sure your code passes all tests and follows the required linting rules.
   - If applicable, add new tests to verify your changes.

6. **Submit a Pull Request (PR)**  
   Once your changes are complete and tested, open a PR against the `main` branch. Provide a detailed description of your changes, referencing any related issues.

### 4. Code Review Process
All PRs will be reviewed by project maintainers. Feedback may be provided, and changes might be requested. Please be open to discussions and willing to make adjustments based on the review.

- **Respond Promptly**: Address review comments promptly to keep the PR moving forward.
- **Stay Technical**: Reviews will be focused on technical merit and alignment with project goals.

### 5. Documentation Contributions
Good documentation is crucial for any project! Contributions to documentation are highly valued. You can:

- Update or improve existing documentation.
- Add new documentation for features, setup instructions, or developer guides.
- Ensure that all code contributions include relevant documentation updates.

### 6. Code Cleanup and Maintenance
Code cleanup, refactoring, and removing unused code are essential contributions that help keep the project healthy. Do not hesitate to submit PRs that address these issues even if they do not add new features.

### 7. Licensing and Dependency Guidelines
- All contributions must comply with the project's [license](LICENSE).
- Be cautious when introducing new dependencies. Avoid dependencies with viral licensing (e.g., GPL) unless discussed and approved by the maintainers.
- Ensure any new dependencies are well-maintained and have a compatible license.

### 8. Contributor Code of Conduct
All contributors must follow the project's [Code of Conduct](CODE_OF_CONDUCT.md) to ensure a welcoming and respectful environment for everyone.

## Getting Help
If you need help or have questions, feel free to reach out by:

- Opening an issue on GitHub.
- Asking on our mailing list or chat channels.
- Reaching out to the maintainers directly.

We appreciate your time and effort in making Plakar better. Happy coding!