/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.content.PathContentSource;

public class PathRequestContent
extends PathContentSource
implements Request.Content {
    private final String contentType;

    public PathRequestContent(Path filePath) throws IOException {
        this(filePath, 4096);
    }

    public PathRequestContent(Path filePath, int bufferSize) throws IOException {
        this("application/octet-stream", filePath, bufferSize);
    }

    public PathRequestContent(String contentType, Path filePath) throws IOException {
        this(contentType, filePath, 4096);
    }

    public PathRequestContent(String contentType, Path filePath, int bufferSize) throws IOException {
        this(contentType, filePath, new ByteBufferPool.Sized(null, false, bufferSize));
    }

    public PathRequestContent(String contentType, Path filePath, ByteBufferPool bufferPool) throws IOException {
        this(contentType, filePath, bufferPool instanceof ByteBufferPool.Sized ? (sized = (ByteBufferPool.Sized)bufferPool) : new ByteBufferPool.Sized(bufferPool));
        ByteBufferPool.Sized sized;
    }

    public PathRequestContent(String contentType, Path filePath, ByteBufferPool.Sized sizedBufferPool) {
        super(filePath, sizedBufferPool);
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

