/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ArnaviTextProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$AV,").number("Vd,").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("-?d+,").expression("[01],").expression("([01]),").number("(d+),").number("d+,d+,").number("d+,d+,").optional().expression("[01],").number("(d+),").groupBegin().number("(d+.d+)?,").number("(?:d+.d+)?,").groupEnd("?").number("(dd)(dd)(dd),").number("(dd)(dd.d+)([NS]),").number("(ddd)(dd.d+)([EW]),").number("(d+.d+),").number("(d+.d+),").number("(dd)(dd)(dd)").any().compile();

    public ArnaviTextProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        Parser parser = new Parser(PATTERN, buf.toString(StandardCharsets.US_ASCII));
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", parser.nextInt());
        position.set("power", (double)parser.nextInt().intValue() * 0.01);
        position.set("battery", (double)parser.nextInt().intValue() * 0.01);
        position.set("ignition", parser.nextInt() == 1);
        position.set("input", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.setAltitude(parser.nextDouble(0.0));
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(true);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextDouble());
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        return position;
    }
}

