/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.functions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.functions.Summarizer;
import org.jxls.functions.SummarizerBuilder;
import org.jxls.transform.TransformationConfig;
import org.jxls.util.Util;

public class GroupSum<T> {
    private final Context context;
    private final SummarizerBuilder<T> sumBuilder;
    private TransformationConfig transformationConfig;
    private String objectVarName = "i";

    public GroupSum(Context context, SummarizerBuilder<T> sumBuilder) {
        this.context = context;
        this.sumBuilder = sumBuilder;
    }

    public T sum(String fieldName, String expression) {
        return this.sum(fieldName, this.getItems(expression));
    }

    public T sum(String fieldName, Collection<Object> collection) {
        Summarizer<T> sum = this.sumBuilder.build();
        for (Object i : collection) {
            sum.add(this.getValue(i, fieldName));
        }
        return sum.getSum();
    }

    public TransformationConfig getTransformationConfig() {
        return this.transformationConfig;
    }

    public void setTransformationConfig(TransformationConfig transformationConfig) {
        this.transformationConfig = transformationConfig;
    }

    public String getObjectVarName() {
        return this.objectVarName;
    }

    public void setObjectVarName(String objectVarName) {
        this.objectVarName = objectVarName;
    }

    public T sum(String fieldName, String expression, String filter) {
        return this.sum(fieldName, this.getItems(expression), filter);
    }

    public T sum(String fieldName, Collection<Object> collection, String filter) {
        if (this.transformationConfig == null) {
            throw new JxlsException("Please set GroupSum.transformationConfig!");
        }
        ExpressionEvaluator expressionEvaluator = this.transformationConfig.getExpressionEvaluator();
        Summarizer<T> sum = this.sumBuilder.build();
        Object oldValue = this.context.getRunVar(this.objectVarName);
        for (Object i : collection) {
            Object value = this.getValue(i, fieldName);
            this.context.putVar(this.objectVarName, i);
            if (Util.isConditionTrue(expressionEvaluator, filter, this.context) != Boolean.TRUE) continue;
            sum.add(value);
        }
        if (oldValue != null) {
            this.context.putVar(this.objectVarName, oldValue);
        } else {
            this.context.removeVar(this.objectVarName);
        }
        return sum.getSum();
    }

    private Object getValue(Object i, String fieldName) {
        if (i instanceof Map) {
            Map map = (Map)i;
            if (!map.containsKey(fieldName)) {
                throw new RuntimeException("Attribute " + fieldName + " does not exist in collection element!");
            }
            return map.get(fieldName);
        }
        try {
            return PropertyUtils.getProperty((Object)i, (String)fieldName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JxlsException(e);
        }
    }

    private Collection<Object> getItems(String expression) {
        Object result = this.getValue(expression);
        if (result == null) {
            throw new NullPointerException("\"" + expression + "\" is null!");
        }
        if (!(result instanceof Collection)) {
            throw new ClassCastException(expression + " is not a Collection!");
        }
        return (Collection)result;
    }

    private Object getValue(String expression) {
        return new JexlExpressionEvaluator(expression).evaluate(this.context.toMap());
    }
}

