/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class Deserializers<K, V>
implements AutoCloseable {
    private final Plugin<Deserializer<K>> keyDeserializerPlugin;
    private final Plugin<Deserializer<V>> valueDeserializerPlugin;

    public Deserializers(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Metrics metrics) {
        this.keyDeserializerPlugin = Plugin.wrapInstance(Objects.requireNonNull(keyDeserializer, "Key deserializer provided to Deserializers should not be null"), metrics, "key.deserializer");
        this.valueDeserializerPlugin = Plugin.wrapInstance(Objects.requireNonNull(valueDeserializer, "Value deserializer provided to Deserializers should not be null"), metrics, "value.deserializer");
    }

    public Deserializers(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Metrics metrics) {
        String clientId = config.getString("client.id");
        if (keyDeserializer == null) {
            keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
            keyDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), true);
        } else {
            config.ignore("key.deserializer");
        }
        this.keyDeserializerPlugin = Plugin.wrapInstance(keyDeserializer, metrics, "key.deserializer");
        if (valueDeserializer == null) {
            valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
            valueDeserializer.configure(config.originals(Collections.singletonMap("client.id", clientId)), false);
        } else {
            config.ignore("value.deserializer");
        }
        this.valueDeserializerPlugin = Plugin.wrapInstance(valueDeserializer, metrics, "value.deserializer");
    }

    public Deserializer<K> keyDeserializer() {
        return this.keyDeserializerPlugin.get();
    }

    public Deserializer<V> valueDeserializer() {
        return this.valueDeserializerPlugin.get();
    }

    @Override
    public void close() {
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        Utils.closeQuietly(this.keyDeserializerPlugin, "key deserializer", firstException);
        Utils.closeQuietly(this.valueDeserializerPlugin, "value deserializer", firstException);
        Throwable exception = firstException.get();
        if (exception != null) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close deserializers", exception);
        }
    }

    public String toString() {
        return "Deserializers{keyDeserializer=" + String.valueOf(this.keyDeserializerPlugin.get()) + ", valueDeserializer=" + String.valueOf(this.valueDeserializerPlugin.get()) + "}";
    }
}

