/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.spi;

import ch.qos.logback.access.common.servlet.Util;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.access.common.spi.ServerAdapter;
import ch.qos.logback.access.common.spi.WrappedHttpRequest;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class AccessEvent
implements Serializable,
IAccessEvent {
    private static final String[] NA_STRING_ARRAY = new String[]{"-"};
    private static final long serialVersionUID = 866718993618836343L;
    private static final String EMPTY = "";
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;
    String queryString;
    String requestURI;
    String requestURL;
    String remoteHost;
    String remoteUser;
    String remoteAddr;
    String threadName;
    String protocol;
    String method;
    String serverName;
    String requestContent;
    String responseContent;
    String sessionID;
    long elapsedTime;
    Map<String, String> requestHeaderMap;
    Map<String, String[]> requestParameterMap;
    Map<String, String> responseHeaderMap;
    Map<String, Object> attributeMap;
    List<Cookie> cookieList;
    long contentLength = -1L;
    int statusCode = -1;
    int localPort = -1;
    transient ServerAdapter serverAdapter;
    private long timeStamp = 0L;
    private long sequenceNumber = 0L;

    public AccessEvent(Context context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServerAdapter adapter) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.timeStamp = System.currentTimeMillis();
        SequenceNumberGenerator sng = context.getSequenceNumberGenerator();
        if (sng != null) {
            this.sequenceNumber = sng.nextSequenceNumber();
        }
        this.serverAdapter = adapter;
        this.elapsedTime = this.calculateElapsedTime();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.httpResponse;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public String getThreadName() {
        return this.threadName == null ? "-" : this.threadName;
    }

    @Override
    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.httpRequest != null ? this.httpRequest.getRequestURI() : "-";
        }
        return this.requestURI;
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null) {
            if (this.httpRequest != null) {
                StringBuilder buf = new StringBuilder();
                String qStr = this.httpRequest.getQueryString();
                if (qStr != null) {
                    buf.append('?');
                    buf.append(qStr);
                }
                this.queryString = buf.toString();
            } else {
                this.queryString = "-";
            }
        }
        return this.queryString;
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL != null) {
            return this.requestURL;
        }
        if (this.httpRequest != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getMethod());
            buf.append(' ');
            buf.append(this.getRequestURI());
            buf.append(this.getQueryString());
            buf.append(' ');
            buf.append(this.getProtocol());
            this.requestURL = buf.toString();
        } else {
            this.requestURL = "-";
        }
        return this.requestURL;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.httpRequest != null ? this.httpRequest.getRemoteHost() : "-";
        }
        return this.remoteHost;
    }

    @Override
    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.httpRequest != null ? this.httpRequest.getRemoteUser() : "-";
        }
        return this.remoteUser;
    }

    @Override
    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.httpRequest != null ? this.httpRequest.getProtocol() : "-";
        }
        return this.protocol;
    }

    @Override
    public String getMethod() {
        if (this.method == null) {
            this.method = this.httpRequest != null ? this.httpRequest.getMethod() : "-";
        }
        return this.method;
    }

    @Override
    public String getSessionID() {
        if (this.sessionID == null) {
            if (this.httpRequest != null) {
                if (this.httpRequest instanceof WrappedHttpRequest) {
                    WrappedHttpRequest wrappedHttpRequest = (WrappedHttpRequest)this.httpRequest;
                    this.sessionID = wrappedHttpRequest.getSessionID();
                } else {
                    HttpSession session = this.httpRequest.getSession(false);
                    if (session != null) {
                        this.sessionID = session.getId();
                    }
                }
            } else {
                this.sessionID = "-";
            }
        }
        return this.sessionID;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpRequest != null ? this.httpRequest.getServerName() : "-";
        }
        return this.serverName;
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : "-";
        }
        return this.remoteAddr;
    }

    @Override
    public String getRequestHeader(String key) {
        String result = null;
        key = key.toLowerCase();
        if (this.requestHeaderMap == null) {
            if (this.httpRequest != null) {
                this.buildRequestHeaderMap();
                result = this.requestHeaderMap.get(key);
            }
        } else {
            result = this.requestHeaderMap.get(key);
        }
        if (result != null) {
            return result;
        }
        return "-";
    }

    @Override
    public Enumeration<String> getRequestHeaderNames() {
        if (this.httpRequest == null) {
            Vector<String> list = new Vector<String>(this.getRequestHeaderMap().keySet());
            return list.elements();
        }
        return this.httpRequest.getHeaderNames();
    }

    @Override
    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.buildRequestHeaderMap();
        }
        return this.requestHeaderMap;
    }

    public void buildRequestHeaderMap() {
        if (this.httpRequest instanceof WrappedHttpRequest) {
            WrappedHttpRequest whr = (WrappedHttpRequest)this.httpRequest;
            this.requestHeaderMap = whr.buildRequestHeaderMap();
        } else {
            this.requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Enumeration e = this.httpRequest.getHeaderNames();
            if (e == null) {
                return;
            }
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.requestHeaderMap.put(key, this.httpRequest.getHeader(key));
            }
        }
    }

    public void buildRequestParameterMap() {
        if (this.httpRequest instanceof WrappedHttpRequest) {
            WrappedHttpRequest whr = (WrappedHttpRequest)this.httpRequest;
            this.requestParameterMap = whr.buildRequestParameterMap();
        } else {
            this.requestParameterMap = new HashMap<String, String[]>();
            try {
                Enumeration e = this.httpRequest.getParameterNames();
                if (e == null) {
                    return;
                }
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.requestParameterMap.put(key, this.httpRequest.getParameterValues(key));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public Map<String, String[]> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.buildRequestParameterMap();
        }
        return this.requestParameterMap;
    }

    @Override
    public String getAttribute(String key) {
        Object value = null;
        if (this.attributeMap != null) {
            value = this.attributeMap.get(key);
        } else if (this.httpRequest != null) {
            value = this.httpRequest.getAttribute(key);
        }
        return value != null ? value.toString() : "-";
    }

    private void copyAttributeMap() {
        if (this.httpRequest == null) {
            return;
        }
        if (this.attributeMap != null) {
            return;
        }
        this.attributeMap = new HashMap<String, Object>();
        Enumeration names = this.httpRequest.getAttributeNames();
        while (names.hasMoreElements()) {
            Object value;
            String name = (String)names.nextElement();
            if (!this.shouldCopyAttribute(name, value = this.httpRequest.getAttribute(name))) continue;
            this.attributeMap.put(name, value);
        }
    }

    private boolean shouldCopyAttribute(String name, Object value) {
        if ("LB_INPUT_BUFFER".equals(name) || "LB_OUTPUT_BUFFER".equals(name)) {
            return false;
        }
        if (value == null) {
            return false;
        }
        return value instanceof Serializable;
    }

    @Override
    public String[] getRequestParameter(String key) {
        String[] value = null;
        if (this.requestParameterMap != null) {
            value = this.requestParameterMap.get(key);
        } else if (this.httpRequest != null) {
            value = this.httpRequest.getParameterValues(key);
        }
        return value != null ? value : NA_STRING_ARRAY;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.cookieList != null) {
            return this.cookieList;
        }
        if (this.httpRequest == null) {
            this.cookieList = List.of();
            return this.cookieList;
        }
        Cookie[] cookieArray = this.httpRequest.getCookies();
        this.cookieList = cookieArray != null ? List.of(cookieArray) : List.of();
        return this.cookieList;
    }

    @Override
    public String getCookie(String key) {
        List<Cookie> cookies = this.getCookies();
        Cookie matchingCookie = cookies.stream().filter(c -> c.getName().equals(key)).findFirst().orElse(null);
        return matchingCookie != null ? matchingCookie.getValue() : "-";
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == -1L && this.httpResponse != null) {
            this.contentLength = this.serverAdapter.getContentLength();
            return this.contentLength;
        }
        return this.contentLength;
    }

    @Override
    public int getStatusCode() {
        if (this.statusCode == -1 && this.httpResponse != null) {
            this.statusCode = this.serverAdapter.getStatusCode();
        }
        return this.statusCode;
    }

    @Override
    public long getElapsedSeconds() {
        return this.elapsedTime < 0L ? this.elapsedTime : this.elapsedTime / 1000L;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    private long calculateElapsedTime() {
        if (this.serverAdapter.getRequestTimestamp() < 0L) {
            return -1L;
        }
        return this.getTimeStamp() - this.serverAdapter.getRequestTimestamp();
    }

    @Override
    public String getRequestContent() {
        if (this.requestContent != null) {
            return this.requestContent;
        }
        if (Util.isFormUrlEncoded(this.httpRequest)) {
            StringBuilder buf = new StringBuilder();
            try {
                Enumeration pramEnumeration = this.httpRequest.getParameterNames();
                int count = 0;
                while (pramEnumeration.hasMoreElements()) {
                    String key = (String)pramEnumeration.nextElement();
                    if (count++ != 0) {
                        buf.append("&");
                    }
                    buf.append(key);
                    buf.append("=");
                    String val = this.httpRequest.getParameter(key);
                    if (val != null) {
                        buf.append(val);
                        continue;
                    }
                    buf.append(EMPTY);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.requestContent = buf.toString();
        } else {
            byte[] inputBuffer = (byte[])this.httpRequest.getAttribute("LB_INPUT_BUFFER");
            if (inputBuffer != null) {
                this.requestContent = new String(inputBuffer);
            }
            if (this.requestContent == null || this.requestContent.length() == 0) {
                this.requestContent = EMPTY;
            }
        }
        return this.requestContent;
    }

    @Override
    public String getResponseContent() {
        if (this.responseContent != null) {
            return this.responseContent;
        }
        if (Util.isImageResponse(this.httpResponse)) {
            this.responseContent = "[IMAGE CONTENTS SUPPRESSED]";
        } else {
            byte[] outputBuffer = (byte[])this.httpRequest.getAttribute("LB_OUTPUT_BUFFER");
            if (outputBuffer != null) {
                this.responseContent = new String(outputBuffer);
            }
            if (this.responseContent == null || this.responseContent.length() == 0) {
                this.responseContent = EMPTY;
            }
        }
        return this.responseContent;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort == -1 && this.httpRequest != null) {
            this.localPort = this.httpRequest.getLocalPort();
        }
        return this.localPort;
    }

    @Override
    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }

    @Override
    public String getResponseHeader(String key) {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap.get(key);
    }

    void buildResponseHeaderMap() {
        if (this.responseHeaderMap == null) {
            this.responseHeaderMap = this.serverAdapter.buildResponseHeaderMap();
        }
    }

    @Override
    public Map<String, String> getResponseHeaderMap() {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap;
    }

    @Override
    public List<String> getResponseHeaderNameList() {
        this.buildResponseHeaderMap();
        return new ArrayList<String>(this.responseHeaderMap.keySet());
    }

    public void prepareForDeferredProcessing() {
        this.getRequestHeaderMap();
        this.getRequestParameterMap();
        this.getResponseHeaderMap();
        this.getLocalPort();
        this.getMethod();
        this.getProtocol();
        this.getRemoteAddr();
        this.getRemoteHost();
        this.getRemoteUser();
        this.getRequestURI();
        this.getRequestURL();
        this.getServerName();
        this.getTimeStamp();
        this.getElapsedTime();
        this.getCookies();
        this.getStatusCode();
        this.getContentLength();
        this.getRequestContent();
        this.getResponseContent();
        this.copyAttributeMap();
    }
}

