/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.StringWriter;
import java.util.regex.Pattern;
import org.jgrapht.Graph;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.IntegerComponentNameProvider;
import org.jgrapht.ext.StringComponentNameProvider;

public class DOTUtils {
    static final String DONT_ALLOW_MULTIPLE_EDGES_KEYWORD = "strict";
    static final String DIRECTED_GRAPH_KEYWORD = "digraph";
    static final String UNDIRECTED_GRAPH_KEYWORD = "graph";
    static final String DIRECTED_GRAPH_EDGEOP = "->";
    static final String UNDIRECTED_GRAPH_EDGEOP = "--";
    private static final Pattern ALPHA_DIG = Pattern.compile("[a-zA-Z]+([\\w_]*)?");
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\".*\"");
    private static final Pattern DOT_NUMBER = Pattern.compile("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
    private static final Pattern HTML = Pattern.compile("<.*>");

    @Deprecated
    public static <V, E> String convertGraphToDotString(Graph<V, E> graph) {
        StringWriter outputWriter = new StringWriter();
        new DOTExporter(new IntegerComponentNameProvider(), new StringComponentNameProvider(), null).exportGraph(graph, outputWriter);
        return outputWriter.toString();
    }

    static boolean isValidID(String idCandidate) {
        return ALPHA_DIG.matcher(idCandidate).matches() || DOUBLE_QUOTE.matcher(idCandidate).matches() || DOT_NUMBER.matcher(idCandidate).matches() || HTML.matcher(idCandidate).matches();
    }
}

