/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.ModifiableCompositeOption;

public class DefaultCompositeOption
implements ModifiableCompositeOption {
    private final List<Option> options = new ArrayList<Option>();

    public DefaultCompositeOption(Option ... options) {
        this.add(options);
    }

    public DefaultCompositeOption() {
    }

    private List<Option> expand(Collection<Option> options) {
        ArrayList<Option> expanded = new ArrayList<Option>();
        if (options != null) {
            for (Option option : options) {
                if (option == null) continue;
                if (option instanceof CompositeOption) {
                    expanded.addAll(Arrays.asList(((CompositeOption)option).getOptions()));
                    continue;
                }
                expanded.add(option);
            }
        }
        return expanded;
    }

    private List<Option> expand(Option ... options) {
        return this.expand(Arrays.asList(options));
    }

    @Override
    public Option[] getOptions() {
        return this.options.toArray(new Option[0]);
    }

    @Override
    public DefaultCompositeOption add(Option ... _options) {
        if (_options != null) {
            List<Option> expanded = this.expand(_options);
            this.options.addAll(expanded);
        }
        return this;
    }

    @Override
    public DefaultCompositeOption remove(Collection<Option> options) {
        List<Option> expanded = this.expand(options);
        this.options.removeAll(expanded);
        return this;
    }

    @Override
    public DefaultCompositeOption remove(Option ... options) {
        return this.remove(Arrays.asList(options));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultCompositeOption");
        sb.append("{options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultCompositeOption other = (DefaultCompositeOption)obj;
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }
}

