/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.io.Writer;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ErrWriter;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.OutWriter;
import org.openide.util.Exceptions;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class NbWriter
extends OutputWriter {
    private final NbIO owner;
    private ErrWriter err = null;

    public NbWriter(OutWriter outWriter, NbIO nbIO) {
        super((Writer)outWriter);
        this.owner = nbIO;
    }

    public void println(String string, OutputListener outputListener) throws IOException {
        ((OutWriter)this.out).println(string, outputListener);
    }

    public void println(String string, OutputListener outputListener, boolean bl) throws IOException {
        ((OutWriter)this.out).println(string, outputListener, bl);
    }

    public synchronized void reset() throws IOException {
        if (!this.out().isDisposed() && this.out().isEmpty()) {
            return;
        }
        if (this.out != null) {
            if (Controller.LOG) {
                Controller.log("Disposing old OutWriter");
            }
            this.out().dispose();
        }
        if (Controller.LOG) {
            Controller.log("NbWriter.reset() replacing old OutWriter");
        }
        this.out = new OutWriter(this.owner);
        this.lock = this.out;
        if (this.err != null) {
            this.err.setWrapped((OutWriter)this.out);
        }
        this.owner.reset();
    }

    OutWriter out() {
        return (OutWriter)this.out;
    }

    ErrWriter err() {
        return this.err;
    }

    public synchronized ErrWriter getErr() {
        if (this.err == null) {
            this.err = new ErrWriter((OutWriter)this.out, this);
        }
        return this.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean bl;
        boolean bl2 = this.isClosed();
        if (Controller.LOG) {
            Controller.log("NbWriter.close wasClosed=" + bl2 + " out is " + this.out + " out is closed " + ((OutWriter)this.out).isClosed());
        }
        if (!bl2 || !((OutWriter)this.out).isClosed()) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (Controller.LOG) {
                        Controller.log("Now closing OutWriter");
                    }
                    this.out.close();
                    if (this.err != null) {
                        this.err.close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (bl2 != (bl = this.isClosed()) && Controller.LOG) {
            Controller.log("Setting streamClosed on InputOutput to " + bl);
        }
        this.owner.setStreamClosed(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        OutWriter outWriter;
        OutWriter outWriter2 = outWriter = (OutWriter)this.out;
        synchronized (outWriter2) {
            boolean bl = outWriter.isClosed();
            if (bl && this.err != null && !outWriter.checkError()) {
                bl &= this.err.isClosed();
            }
            return bl;
        }
    }

    public void notifyErrClosed() {
        if (this.isClosed()) {
            if (Controller.LOG) {
                Controller.log("NbWriter.notifyErrClosed - error stream has been closed");
            }
            this.owner.setStreamClosed(this.isClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            ((OutWriter)this.out).println(string);
        }
    }
}

